/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.data.impl;

import ec.gob.sri.anexo.catalogo.api.enums.FuenteEnum;
import ec.gob.sri.anexo.catalogo.api.excepciones.GetObjetoException;
import ec.gob.sri.anexo.catalogo.api.excepciones.InstaciacionExcepcion;
import ec.gob.sri.anexo.catalogo.api.utils.MultiKey;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministracionCargaParamRetBananoTarifaImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaConceptosRetencionImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaRegimenesImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaRetencionDividendosImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaSecuencialesComprobantesImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaSecuencialesImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaSustentoComprobantesImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministrarCargaComprobantesImpl;
import ec.gob.sri.anexo.catalogo.modelo.ItemComprobantesValidacion;
import ec.gob.sri.anexo.catalogo.modelo.ItemConceptosRetencionValidacion;
import ec.gob.sri.anexo.catalogo.modelo.ItemRegimenAduaneroValidacion;
import ec.gob.sri.anexo.catalogo.modelo.ItemRetencionDividendos;
import ec.gob.sri.anexo.catalogo.modelo.ItemSecuencialComprobanteValidacion;
import ec.gob.sri.anexo.catalogo.modelo.ItemSecuencialSustentoValidacion;
import ec.gob.sri.anexo.catalogo.modelo.ParaisoFiscal;
import ec.gob.sri.anexo.catalogo.modelo.ParametrosRetencionBananoTarifa;
import ec.gob.sri.anexo.catalogo.modelo.RigDetalleCatalogo;
import ec.gob.sri.anexo.catalogo.modelo.SecuencialesTransacciones;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.data.impl.ConexionBD;
import ec.gob.sri.dimm.data.impl.Constantes;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public final class UtilCatalogosATS
extends DataCatalogos {
    private static final String DISTRITOS = "DISTRITOS";
    private static final String TIPOSEXP = "TIPOSEXP";
    private static final String CAT_PORCENTAJE_IVA = "PORCIVA";
    private static final String CAT_TIPOS_FIDEICOMISOS = "TIPOFIDE";
    private static final String CAT_FORMAS_PAGO = "FORMPAGO";
    private static final String CAT_TIPOS_REGIMEN_FISCAL = "TIPOREGIMENEXT";
    private static final String CATALOGO_TIPOS_INGRESO_DEL_EXTERIOR = "TIPOINGRESOEXT";
    public static final String COMPENSACIONES = "COMPENSACIONES";
    private static final String TIPO_EMISION_COMPROBANTES = "TIPOEMISION";
    private static final String TIPO_DE_CONTRIBUYENTE = "TIPOSIDPROV";
    private static final String PORCENTAJE_COMPENSACION = "PORCENTAJE_COMPENSAC";
    public static final String FRACCION_BASICA = "fraccionBasica";
    public static final String EXCESO_HASTA = "excesoHasta";
    public static final String RETENCION_SOBRE_FRACCION = "retencionSobreFraccionBase";
    public static final String PORCENTAJE_DE_RETENCION = "porcentajeRetencion";
    public static final String TARIFA = "tarifa";
    public static final String NUMERO_MINIMO_CAJAS = "numeroMinimo";
    public static final String NUMERO_MAXIMO_CAJAS = "numeroMaximo";
    public static final String CAMPO = "numeroCampo";
    private static final Object bloqueoInstancia = new Object();
    private static UtilCatalogosATS instancia = null;
    private static AdministradorCargaRegimenesImpl admRegimenes;
    private static AdministradorCargaSecuencialesComprobantesImpl admSecuencialesComprobantes;
    private static AdministradorCargaSecuencialesImpl admSecuenciales;
    private static AdministradorCargaSustentoComprobantesImpl admSustentoComprobantes;
    private static AdministrarCargaComprobantesImpl admComprobantes;
    private static AdministradorCargaConceptosRetencionImpl administradorCargaConceptosRetencion;
    private static AdministradorCargaRetencionDividendosImpl administradorCargaRetencionDividendos;
    private static AdministracionCargaParamRetBananoTarifaImpl administradorTarifasBanano;

    private UtilCatalogosATS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UtilCatalogosATS crearInstancia() {
        Object object = bloqueoInstancia;
        synchronized (object) {
            if (instancia == null) {
                instancia = new UtilCatalogosATS();
            }
        }
        return instancia;
    }

    public ItemComprobantesValidacion obtenerComprobante(String codigoTipoComprobante) {
        return (ItemComprobantesValidacion)admComprobantes.getObjeto((Object)Integer.parseInt(codigoTipoComprobante));
    }

    public SecuencialesTransacciones obtenerInfoTransaccion(String codigoSecuencialTransaccion, String codigoTipoTransaccion) {
        MultiKey datos = new MultiKey(new Object[]{codigoSecuencialTransaccion, codigoTipoTransaccion});
        return (SecuencialesTransacciones)admSecuenciales.getObjeto((Object)datos);
    }

    public ItemSecuencialComprobanteValidacion obtenerTipoComprobante(String codigoSecuencialTrans, String codigoTipoComprobante, String codigoTipoTrans) {
        MultiKey mk = new MultiKey(new Object[]{codigoSecuencialTrans, codigoTipoComprobante, codigoTipoTrans});
        return (ItemSecuencialComprobanteValidacion)admSecuencialesComprobantes.getObjeto((Object)mk);
    }

    public ItemConceptosRetencionValidacion obtenerRetencion(String numeroCampo, String mesPeriodo, String anioPeriodo) throws GetObjetoException {
        return administradorCargaConceptosRetencion.getObjetoConDatos(numeroCampo, new Object[]{mesPeriodo, anioPeriodo});
    }

    @Override
    public Map<String, BigDecimal> obtenerRetencionDividendosPorBaseImponible(BigDecimal baseImponible, Date fechaRegistroComprobante) {
        GregorianCalendar registroComprobante = new GregorianCalendar();
        registroComprobante.setTime(fechaRegistroComprobante);
        for (ItemRetencionDividendos retencionDividendos : administradorCargaRetencionDividendos.getLista()) {
            if (baseImponible.compareTo(retencionDividendos.getFraccionBasica()) < 0 || baseImponible.compareTo(retencionDividendos.getExcesoHasta()) > 0 || retencionDividendos.getFechaDesde().compareTo(registroComprobante) > 0 || retencionDividendos.getFechaHasta() != null && retencionDividendos.getFechaHasta().compareTo(registroComprobante) < 0) continue;
            Hashtable<String, BigDecimal> itemRetencionDividendos = new Hashtable<String, BigDecimal>();
            itemRetencionDividendos.put(FRACCION_BASICA, retencionDividendos.getFraccionBasica());
            itemRetencionDividendos.put(EXCESO_HASTA, retencionDividendos.getExcesoHasta());
            itemRetencionDividendos.put(RETENCION_SOBRE_FRACCION, retencionDividendos.getRetencionSobreFraccionBasica());
            itemRetencionDividendos.put(PORCENTAJE_DE_RETENCION, retencionDividendos.getPorcentajeDeRetencion());
            return itemRetencionDividendos;
        }
        return null;
    }

    public Map<String, String[]> obtenerRentenciones(int mes, int anio, String esMicroempresa, Date fechaSeleccContable) {
        LinkedHashMap<String, String[]> resultado = new LinkedHashMap<String, String[]>();
        try {
            List items = null;
            if ("SI".equals(esMicroempresa) && fechaSeleccContable != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(fechaSeleccContable);
                anio = calendar.get(1);
                mes = calendar.get(2) + 1;
            }
            items = administradorCargaConceptosRetencion.obtenerRetencionesPeriodo(mes, anio);
            for (ItemConceptosRetencionValidacion item : items) {
                BigDecimal bd = new BigDecimal(item.getPorcentaje());
                bd = bd.setScale(2, 6);
                resultado.put(item.getNumeroCampo(), new String[]{item.getNombreCampo(), item.getMarcaPorcentajeLibre().equals("S") ? null : bd.toString()});
            }
        }
        catch (GetObjetoException e) {
            e.printStackTrace();
        }
        return resultado;
    }

    private String getFechaFormateada(Date fechaSeleccContable) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-mm-dd");
        return dateFormat.format(fechaSeleccContable);
    }

    public RigDetalleCatalogo obtenerDetalleCatalogo(String nemonicoCatalogo, String valorElemento) {
        return ac.getValor(nemonicoCatalogo, valorElemento);
    }

    public void inicializarCatalogos() throws SQLException {
        block14: {
            Connection con = null;
            try {
                try {
                    ConexionBD cbdd = new ConexionBD();
                    con = cbdd.obtenerConexion();
                    UtilCatalogosATS.inicializarCatalogosATS(FuenteEnum.DIMM, con);
                }
                catch (Exception e) {
                    PluginLogger.logError((String)"Carga de catalogos ATS erronea", (String)"ec.gob.sri.dimm.data", (Exception)e);
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException sQLException) {
                            PluginLogger.logError((String)"incializarCatalogos() --> NO se ha podido cerrar la conexion", (String)"ec.gob.sri.dimm.data");
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {
                        PluginLogger.logError((String)"incializarCatalogos() --> NO se ha podido cerrar la conexion", (String)"ec.gob.sri.dimm.data");
                    }
                }
                throw throwable;
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    PluginLogger.logError((String)"incializarCatalogos() --> NO se ha podido cerrar la conexion", (String)"ec.gob.sri.dimm.data");
                }
            }
        }
    }

    private static boolean inicializarCatalogosATS(FuenteEnum servidor, Connection conexion) throws SQLException {
        boolean resultado;
        try {
            admRegimenes = AdministradorCargaRegimenesImpl.getInstancia((FuenteEnum)servidor);
            admRegimenes.inicializar(conexion);
            admSecuencialesComprobantes = AdministradorCargaSecuencialesComprobantesImpl.getInstancia((FuenteEnum)servidor);
            admSecuencialesComprobantes.inicializar(conexion);
            admSecuenciales = AdministradorCargaSecuencialesImpl.getInstancia((FuenteEnum)servidor);
            admSecuenciales.inicializar(conexion);
            admSustentoComprobantes = AdministradorCargaSustentoComprobantesImpl.getInstancia((FuenteEnum)servidor);
            admSustentoComprobantes.inicializar(conexion);
            admComprobantes = AdministrarCargaComprobantesImpl.getInstancia((FuenteEnum)servidor);
            admComprobantes.inicializar(conexion);
            administradorCargaConceptosRetencion = AdministradorCargaConceptosRetencionImpl.getInstancia((FuenteEnum)servidor);
            administradorCargaConceptosRetencion.inicializar(conexion);
            administradorCargaRetencionDividendos = AdministradorCargaRetencionDividendosImpl.getInstancia((FuenteEnum)servidor);
            administradorCargaRetencionDividendos.inicializar(conexion);
            administradorTarifasBanano = AdministracionCargaParamRetBananoTarifaImpl.getInstancia((FuenteEnum)servidor);
            administradorTarifasBanano.inicializar(conexion);
            resultado = true;
        }
        catch (InstaciacionExcepcion instaciacionExcepcion) {
            PluginLogger.logError((String)"Error al obtener instancia de los catalogos de ATS", (String)"ec.gob.sri.dimm.data");
            resultado = false;
        }
        return resultado;
    }

    public List<Map<String, Object>> obtenerParametrosBananoPorCodigoRetencion(Long claveMapa, String numeroCampo, long numeroCajas) {
        ArrayList<Map<String, Object>> parametros = new ArrayList<Map<String, Object>>();
        try {
            List listaObjetoConDatos = administradorTarifasBanano.getListaObjetoConDatos(claveMapa, new Object[]{numeroCampo, numeroCajas});
            for (ParametrosRetencionBananoTarifa parametrosRetencionBananoTarifa : listaObjetoConDatos) {
                Hashtable<String, Object> parametroBanano = new Hashtable<String, Object>();
                parametroBanano.put(TARIFA, parametrosRetencionBananoTarifa.getTarifa());
                parametroBanano.put(NUMERO_MAXIMO_CAJAS, parametrosRetencionBananoTarifa.getNumeroMaximoCajas());
                parametroBanano.put(NUMERO_MINIMO_CAJAS, parametrosRetencionBananoTarifa.getNumeroMinimoCajas());
                parametroBanano.put(CAMPO, parametrosRetencionBananoTarifa.getNumeroCampo());
                parametros.add(parametroBanano);
            }
            return parametros;
        }
        catch (GetObjetoException getObjetoException) {
            return Collections.EMPTY_LIST;
        }
    }

    public Map<String, String> obtenerTiposDeContribuyente() {
        return this.obtenerMapaDeCatalogoGenericoPorNemonico(TIPO_DE_CONTRIBUYENTE);
    }

    public Map<String, String> obtenerTiposDeIngresoDelExteriorPorPeriodo(LocalDate fechaAnexo) {
        return this.obtenerMapaDeCatalogoGenericoPorPeriodo(fechaAnexo, CATALOGO_TIPOS_INGRESO_DEL_EXTERIOR);
    }

    private Map<String, String> obtenerMapaDeCatalogoGenericoPorPeriodo(LocalDate fechaAnexo, String nemonicoCatalogo) {
        TreeMap<String, String> mapaCatalogo = new TreeMap<String, String>();
        Map valoresCatalogo = ac.getValoresCatalogo(nemonicoCatalogo);
        for (Map.Entry itemCatalogo : valoresCatalogo.entrySet()) {
            LocalDate fechaFin;
            LocalDate fechaInicio = new LocalDate(((RigDetalleCatalogo)itemCatalogo.getValue()).getFechaIncio().getTime());
            LocalDate localDate = fechaFin = ((RigDetalleCatalogo)itemCatalogo.getValue()).getFechaFin() == null ? null : new LocalDate(((RigDetalleCatalogo)itemCatalogo.getValue()).getFechaFin().getTime());
            if (!this.fechaMayorOIgualQue(fechaAnexo, fechaInicio) || fechaFin != null && !this.fechaMayorOIgualQue(fechaFin, fechaAnexo)) continue;
            mapaCatalogo.put((String)itemCatalogo.getKey(), ((RigDetalleCatalogo)itemCatalogo.getValue()).getNombreDetalleCatalogo());
        }
        return mapaCatalogo;
    }

    public Map<String, String> obtenerFideicomisos(LocalDate fechaAnexo) {
        return this.obtenerMapaDeCatalogoGenericoPorPeriodo(fechaAnexo, CAT_TIPOS_FIDEICOMISOS);
    }

    public Map<String, AbstractMap.SimpleEntry<String, BigDecimal>> obtenerCompensacionesPorPeriodo(LocalDate fechaAnexo) {
        return this.obtenerMapaConValorNumericoDeCatalogo(fechaAnexo, COMPENSACIONES);
    }

    public Map<String, String> obtenerFormasDePago(LocalDate fechaAnexo) {
        return this.obtenerMapaDeCatalogoGenericoPorPeriodo(fechaAnexo, CAT_FORMAS_PAGO);
    }

    public Map<String, AbstractMap.SimpleEntry<String, BigDecimal>> obtenerPorcentajeCompensacionesPorPeriodo(LocalDate fechaAnexo) {
        return this.obtenerMapaConValorNumericoDeCatalogo(fechaAnexo, PORCENTAJE_COMPENSACION);
    }

    private Map<String, AbstractMap.SimpleEntry<String, BigDecimal>> obtenerMapaConValorNumericoDeCatalogo(LocalDate fechaAnexo, String nemonico) {
        TreeMap<String, AbstractMap.SimpleEntry<String, BigDecimal>> items = new TreeMap<String, AbstractMap.SimpleEntry<String, BigDecimal>>();
        for (Map.Entry itemCatalogo : ac.getValoresCatalogo(nemonico).entrySet()) {
            LocalDate fechaInicio = new LocalDate(((RigDetalleCatalogo)itemCatalogo.getValue()).getFechaIncio().getTime());
            if (!this.fechaMayorOIgualQue(fechaAnexo, fechaInicio) || ((RigDetalleCatalogo)itemCatalogo.getValue()).getFechaFin() != null && !this.fechaMayorOIgualQue(new LocalDate(((RigDetalleCatalogo)itemCatalogo.getValue()).getFechaFin().getTime()), fechaAnexo)) continue;
            items.put((String)itemCatalogo.getKey(), new AbstractMap.SimpleEntry<String, BigDecimal>(((RigDetalleCatalogo)itemCatalogo.getValue()).getNombreDetalleCatalogo(), ((RigDetalleCatalogo)itemCatalogo.getValue()).getValorNumerico()));
        }
        return items;
    }

    private Map<String, String> obtenerMapaDeCatalogoGenericoPorNemonico(String nemonicoCatalogo) {
        LinkedHashMap<String, String> mapaCatalogo = new LinkedHashMap<String, String>();
        Map valores = ac.getValoresCatalogo(nemonicoCatalogo);
        for (Map.Entry item : valores.entrySet()) {
            mapaCatalogo.put((String)item.getKey(), ((RigDetalleCatalogo)item.getValue()).getNombreDetalleCatalogo());
        }
        return mapaCatalogo;
    }

    public BigDecimal obtenerPorcentajeIVA(int anio, int mes) {
        Calendar calendario = GregorianCalendar.getInstance();
        calendario.set(anio, mes - 1, 1, 0, 0, 0);
        BigDecimal porcentaje = null;
        Date fechaPeriodo = calendario.getTime();
        Map porcentajesIVA = ac.getValoresCatalogo(CAT_PORCENTAJE_IVA);
        for (RigDetalleCatalogo detallePorcentaje : porcentajesIVA.values()) {
            calendario.clear();
            if (detallePorcentaje.getFechaFin() == null) {
                calendario.set(2050, 0, 1, 0, 0, 0);
            } else {
                calendario.setTime(detallePorcentaje.getFechaFin());
                calendario.add(5, 1);
            }
            Date fechaInicioSiguientePeriodo = calendario.getTime();
            if (!fechaPeriodo.before(fechaInicioSiguientePeriodo) || fechaPeriodo.before(detallePorcentaje.getFechaIncio())) continue;
            porcentaje = detallePorcentaje.getValorNumerico();
            break;
        }
        return porcentaje == null ? null : porcentaje.divide(Constantes.CIEN);
    }

    public Map<String, String> obtenerComprobantesPorTransaccionIdentificacion(String transaccion, String tipoIdentificacion) {
        LinkedHashMap<String, String> comprobantes = new LinkedHashMap<String, String>();
        String codigoIdentificacion = this.obtenerTipoIdentificacion(transaccion, tipoIdentificacion);
        for (ItemSecuencialComprobanteValidacion secuencial : admSecuencialesComprobantes.getListaComprobantesPorTransaccion(transaccion)) {
            MultiKey datos = new MultiKey(new Object[]{codigoIdentificacion, secuencial.getCodigoTipoComprobante(), transaccion});
            if (!admSecuencialesComprobantes.verificar((Object)datos)) continue;
            comprobantes.put(secuencial.getCodigoTipoComprobante(), secuencial.getDescripcionComprobante());
        }
        return comprobantes;
    }

    public Map<String, String> obtenerComprobantesPorTransaccionIdentificacionPeriodo(String transaccion, String tipoIdentificacion, int anio, int mes) {
        LinkedHashMap<String, String> comprobantes = new LinkedHashMap<String, String>();
        String codigoIdentificacion = this.obtenerTipoIdentificacion(transaccion, tipoIdentificacion);
        Calendar fechaDeclaracion = Calendar.getInstance();
        fechaDeclaracion.set(anio, mes - 1, 1, 0, 0, 0);
        fechaDeclaracion.set(14, 0);
        Calendar fechaInicio = Calendar.getInstance();
        Calendar fechaFin = Calendar.getInstance();
        for (ItemSecuencialComprobanteValidacion secuencial : admSecuencialesComprobantes.getListaComprobantesPorTransaccion(transaccion)) {
            MultiKey datos = new MultiKey(new Object[]{codigoIdentificacion, secuencial.getCodigoTipoComprobante(), transaccion});
            fechaInicio.setTime(secuencial.getFechaDesde());
            if (!admSecuencialesComprobantes.verificar((Object)datos) || fechaInicio.compareTo(fechaDeclaracion) > 0) continue;
            if (secuencial.getFechaHasta() == null) {
                if (!secuencial.getCodigoSecuencialTransaccion().equals(codigoIdentificacion)) continue;
                comprobantes.put(secuencial.getCodigoTipoComprobante(), secuencial.getDescripcionComprobante());
                continue;
            }
            fechaFin.setTime(secuencial.getFechaHasta());
            if (fechaFin.compareTo(fechaDeclaracion) < 0) continue;
            comprobantes.put(secuencial.getCodigoTipoComprobante(), secuencial.getDescripcionComprobante());
        }
        return comprobantes;
    }

    public Map<String, String> obtenerComprobantes() {
        LinkedHashMap<String, String> comprobantes = new LinkedHashMap<String, String>();
        for (ItemComprobantesValidacion item : admComprobantes.getLista()) {
            comprobantes.put(item.getCodigo() < 10 ? "0" + item.getCodigo() : String.valueOf(item.getCodigo()), item.getDescripcion());
        }
        return comprobantes;
    }

    public Map<String, String> obtenerComprobantesPorPeriodo(int anio, int mes) {
        LinkedHashMap<String, String> comprobantes = new LinkedHashMap<String, String>();
        Calendar fechaDeclaracion = Calendar.getInstance();
        fechaDeclaracion.set(anio, mes - 1, 1, 0, 0, 0);
        fechaDeclaracion.set(14, 0);
        Calendar fechaInicio = Calendar.getInstance();
        Calendar fechaFin = Calendar.getInstance();
        for (ItemComprobantesValidacion item : admComprobantes.getLista()) {
            fechaInicio.setTime(item.getFechaDesde());
            if (fechaInicio.compareTo(fechaDeclaracion) > 0) continue;
            if (item.getFechaHasta() == null) {
                comprobantes.put(item.getCodigo() < 10 ? "0" + item.getCodigo() : String.valueOf(item.getCodigo()), item.getDescripcion());
                continue;
            }
            fechaFin.setTime(item.getFechaHasta());
            if (fechaFin.compareTo(fechaDeclaracion) < 0) continue;
            comprobantes.put(item.getCodigo() < 10 ? "0" + item.getCodigo() : String.valueOf(item.getCodigo()), item.getDescripcion());
        }
        return comprobantes;
    }

    public Map<String, String> obtenerComprobantesPorTransaccion(String transaccion) {
        LinkedHashMap<String, String> comprobantes = new LinkedHashMap<String, String>();
        for (ItemSecuencialComprobanteValidacion secuencial : admSecuencialesComprobantes.getListaComprobantesPorTransaccion(transaccion)) {
            comprobantes.put(secuencial.getCodigoTipoComprobante(), secuencial.getDescripcionComprobante());
        }
        return comprobantes;
    }

    public Map<String, String> obtenerComprobantesPorTransaccion(String transaccion, LocalDate fechaDeclarada) {
        LinkedHashMap<String, String> comprobantes = new LinkedHashMap<String, String>();
        for (ItemSecuencialComprobanteValidacion secuencial : admSecuencialesComprobantes.getListaComprobantesPorTransaccion(transaccion)) {
            LocalDate fechaFin;
            LocalDate fechaInicio = new LocalDate(secuencial.getFechaDesde().getTime());
            LocalDate localDate = fechaFin = secuencial.getFechaHasta() == null ? null : new LocalDate(secuencial.getFechaHasta().getTime());
            if (!this.fechaMayorOIgualQue(fechaDeclarada, fechaInicio) || fechaFin != null && !this.fechaMayorOIgualQue(fechaFin, fechaDeclarada)) continue;
            comprobantes.put(secuencial.getCodigoTipoComprobante(), secuencial.getDescripcionComprobante());
        }
        return comprobantes;
    }

    public Map<String, String> obtenerDistritosAduaneros() {
        LinkedHashMap<String, String> retorno = new LinkedHashMap<String, String>();
        for (Map.Entry distrito : ac.getValoresCatalogo(DISTRITOS).entrySet()) {
            retorno.put(((RigDetalleCatalogo)distrito.getValue()).getValorCatalogo(), ((RigDetalleCatalogo)distrito.getValue()).getNombreDetalleCatalogo());
        }
        return retorno;
    }

    public Map<String, String> obtenerTipoExportaciones() {
        LinkedHashMap<String, String> retorno = new LinkedHashMap<String, String>();
        for (Map.Entry tiposExp : ac.getValoresCatalogo(TIPOSEXP).entrySet()) {
            retorno.put(((RigDetalleCatalogo)tiposExp.getValue()).getValorCatalogo(), ((RigDetalleCatalogo)tiposExp.getValue()).getNombreDetalleCatalogo());
        }
        return retorno;
    }

    public String obtenerTipoIdentificacion(String tipoTransaccion, String tipoIdentificacion) {
        for (SecuencialesTransacciones dc : admSecuenciales.getLista()) {
            if (!dc.getCodigoTipoTransaccion().equals(tipoTransaccion) || !dc.getCodigoIdentificacion().equals(tipoIdentificacion)) continue;
            return dc.getCodigoSecuencTrans();
        }
        return "";
    }

    public Map<String, String> obtenerRegimenesAduaneros(boolean regimenEcuapass) {
        LinkedHashMap<String, String> resultado = new LinkedHashMap<String, String>();
        for (ItemRegimenAduaneroValidacion item : admRegimenes.getLista()) {
            if (regimenEcuapass && item.getTipoRegimen().contains("EXPORTACION") && item.getCodigoRegimenEcuapass().equals("S")) {
                resultado.put(item.getCodigoRegimen(), item.getDescripcionRegimen());
                continue;
            }
            if (regimenEcuapass || !item.getCodigoRegimenEcuapass().equals("N")) continue;
            resultado.put(item.getCodigoRegimenSice(), item.getDescriRegimenSice());
        }
        return resultado;
    }

    public Map<String, Map<String, Set<String>>> obtenerSustentosComprobante(String tipoTransaccion, int anio, int mes) {
        LinkedHashMap<String, Map<String, Set<String>>> sustentos = new LinkedHashMap<String, Map<String, Set<String>>>();
        Calendar fechaDeclaracion = Calendar.getInstance();
        fechaDeclaracion.set(anio, mes - 1, 1, 0, 0, 0);
        fechaDeclaracion.set(14, 0);
        for (ItemSecuencialSustentoValidacion sustento : admSustentoComprobantes.getLista()) {
            if (!sustento.getCodigoTipoTransaccion().equals(tipoTransaccion)) continue;
            Calendar fechaInicio = Calendar.getInstance();
            fechaInicio.setTime(sustento.getFechaDesde());
            boolean esValido = false;
            if (fechaInicio.compareTo(fechaDeclaracion) > 0) continue;
            if (sustento.getFechaHasta() == null) {
                esValido = true;
            } else {
                Calendar fechaFin = Calendar.getInstance();
                fechaFin.setTime(sustento.getFechaHasta());
                if (fechaFin.compareTo(fechaDeclaracion) >= 0) {
                    esValido = true;
                }
            }
            if (!esValido) continue;
            if (sustentos.containsKey(sustento.getCodigoSustentoTributario())) {
                Set comprobantesExistentes = (Set)((Map)sustentos.get(sustento.getCodigoSustentoTributario())).get(sustento.getDescripcionSustento());
                comprobantesExistentes.add(sustento.getCodigoTipoComprobante());
                continue;
            }
            LinkedHashMap sustentoComprobante = new LinkedHashMap();
            HashSet<String> comprobantes = new HashSet<String>();
            comprobantes.add(sustento.getCodigoTipoComprobante());
            sustentoComprobante.put(sustento.getDescripcionSustento(), comprobantes);
            sustentos.put(sustento.getCodigoSustentoTributario(), sustentoComprobante);
        }
        return sustentos;
    }

    public String obtenerTipoIdentificacionSecuencia(String tipoTransaccion, String codigoSecuencia) {
        for (SecuencialesTransacciones dc : admSecuenciales.getLista()) {
            if (!dc.getCodigoTipoTransaccion().equals(tipoTransaccion) || !dc.getCodigoSecuencTrans().equals(codigoSecuencia)) continue;
            return dc.getCodigoIdentificacion();
        }
        return "";
    }

    public String obtenerDescripcionComprobante(String tipoComprobante) {
        return ((ItemComprobantesValidacion)admComprobantes.getObjeto((Object)Integer.parseInt(tipoComprobante))).getDescripcion();
    }

    public String obtenerDescripcionDistritoAduanero(String tipoDistrito) {
        return ac.getValor(DISTRITOS, tipoDistrito).getNombreDetalleCatalogo();
    }

    public String obtenerDescripcionRegimenAduanero(String tipoRegimen, boolean regimenEcuapass) {
        return regimenEcuapass ? ((ItemRegimenAduaneroValidacion)admRegimenes.getObjeto((Object)tipoRegimen)).getDescripcionRegimen() : ((ItemRegimenAduaneroValidacion)admRegimenes.getObjeto((Object)tipoRegimen)).getDescriRegimenSice();
    }

    public String obtenerDescripcionSustento(String codigoSustento) {
        for (ItemSecuencialSustentoValidacion sustento : admSustentoComprobantes.getLista()) {
            if (!sustento.getCodigoSustentoTributario().equals(codigoSustento)) continue;
            return sustento.getDescripcionSustento();
        }
        return "";
    }

    public String obtenerDescripcionRetencion(String numeroCampo, String mesPeriodo, String anioPeriodo, String esMicroEmpresa) {
        try {
            return administradorCargaConceptosRetencion.getObjetoConDatos(numeroCampo, new Object[]{mesPeriodo, anioPeriodo, esMicroEmpresa}).getNombreCampo();
        }
        catch (GetObjetoException e) {
            PluginLogger.logError((String)e.getMessage(), (String)"ec.gob.sri.dimm.data");
            return "";
        }
    }

    public BigDecimal obtenerPorcentajeCompensacion(String codigoCompensacion) {
        RigDetalleCatalogo valor = this.obtenerValor(COMPENSACIONES, codigoCompensacion);
        return valor.getValorNumerico();
    }

    public Map<String, String> obtenerTiposDeEmisionDeComprobantes() {
        TreeMap<String, String> tiposDeEmision = new TreeMap<String, String>();
        for (Map.Entry tipoEmision : ac.getValoresCatalogo(TIPO_EMISION_COMPROBANTES).entrySet()) {
            tiposDeEmision.put((String)tipoEmision.getKey(), ((RigDetalleCatalogo)tipoEmision.getValue()).getValorCatalogo());
        }
        return tiposDeEmision;
    }

    public BigDecimal obtenerPorcentajeFideicomiso(String codigoFideicomiso) {
        return ac.getValor(CAT_TIPOS_FIDEICOMISOS, codigoFideicomiso).getValorNumerico();
    }

    public Map<String, String> obtenerTiposDeRegimenFiscalDelExterior() {
        LinkedHashMap<String, String> tiposRegimenfiscal = new LinkedHashMap<String, String>();
        Map valores = ac.getValoresCatalogo(CAT_TIPOS_REGIMEN_FISCAL);
        for (Map.Entry item : valores.entrySet()) {
            tiposRegimenfiscal.put((String)item.getKey(), ((RigDetalleCatalogo)item.getValue()).getNombreDetalleCatalogo());
        }
        return tiposRegimenfiscal;
    }

    public Map<Integer, Map<String, String>> obtenerParaisosFiscalesPorFechaDeclarada(LocalDate fechaDeclaracion) {
        TreeMap<Integer, Map<String, String>> mapaParaisosFiscales = new TreeMap<Integer, Map<String, String>>();
        Map paraisosFiscalesdelCatalogo = new TreeMap();
        paraisosFiscalesdelCatalogo = acParaisosFiscales.obtenerParaisosFiscalesPorFechaDeclaracion(fechaDeclaracion);
        TreeMap<String, String> mapaPaisParaiso = null;
        for (Map.Entry paraisoCatalogo : paraisosFiscalesdelCatalogo.entrySet()) {
            mapaPaisParaiso = new TreeMap<String, String>();
            mapaPaisParaiso.put(((ParaisoFiscal)paraisoCatalogo.getValue()).getCodigoPais().toString(), ((ParaisoFiscal)paraisoCatalogo.getValue()).getNombreParaisoFiscal());
            Integer idParaisoFiscal = Integer.parseInt(((ParaisoFiscal)paraisoCatalogo.getValue()).getIdentificadorParaisoFiscal().toString());
            mapaParaisosFiscales.put(idParaisoFiscal, mapaPaisParaiso);
        }
        return mapaParaisosFiscales;
    }

    private boolean fechaMayorOIgualQue(LocalDate fechaDeclaracion, LocalDate fechaInicio) {
        return fechaDeclaracion.isAfter((ReadablePartial)fechaInicio) || fechaDeclaracion.isEqual((ReadablePartial)fechaInicio);
    }

    public static /* bridge */ /* synthetic */ DataCatalogos crearInstancia() {
        return UtilCatalogosATS.crearInstancia();
    }
}

